<?php
/*
  Plugin Name: Thanoz - AI Assistant
  Plugin URI: https://thanoz.com/plugins/
  Description: KI Service-Assistent für Ihre Webseite, einen Shop oder Ihre Dienstleistung
  Version: 1.5.14
  Author: IT-Service DGO
  Author URI: https://dgoit.de
  License: dgoit
  License URI: https://dgoit.de/plugins/
  Text Domain: thanoz
  Domain Path: /languages
*/
/* ************************************************    Thanoz AI-Assistant    *********************************************
*/


if (!defined('ABSPATH')) exit;


class thanozassistant
{

    public function __construct()
    {
        add_action('admin_menu', [$this, 'add_admin_menu']);
        add_action('admin_init', [$this, 'register_settings']);
        add_action('admin_notices', [$this, 'admin_notices']);
    }


    public function add_admin_menu()
    {
        add_menu_page(
            'Thanoz',
            'Thanoz',
            'manage_options',
            'thanoz-settings',
            [$this, 'settings_page'],
            // 'dashicons-awards', // Top-Trust Fallback icon
            'dashicons-rest-api', // Thanoz-RestApi-Icon
            2
        );
    }




    public function admin_notices()
    {
        if (!isset($_GET['page']) || $_GET['page'] !== 'thanoz-settings') return;

        if (isset($_GET['settings-updated']) && $_GET['settings-updated'] === 'true') {
            echo '<div class="notice notice-success is-dismissible"><p>Einstellungen erfolgreich gespeichert.</p></div>';
        } elseif (isset($_GET['settings-updated']) && $_GET['settings-updated'] === 'false') {
            echo '<div class="notice notice-error is-dismissible"><p>Es gab einen Fehler beim Abspeichern der Einstellungen.</p></div>';
        }
    }



    public function register_settings()
    {
        register_setting('toptrust_settings_group', 'TOPTRUST_API_KEY');
        register_setting('toptrust_settings_group', 'TOPTRUST_AJAX_DATA_URL_SSL');

        // Post types 
        register_setting(
            'toptrust_settings_group',
            'thanoz-assistant_post_types',
            [
                'type'              => 'array',
                'sanitize_callback' => function ($input) {
                    if (!is_array($input)) {
                        return [];
                    }
                    return array_map('sanitize_text_field', $input); // post type slugs
                },
                'default' => [],
            ]
        );

        // Excluded pages 
        register_setting(
            'toptrust_settings_group',
            'thanoz-assistant_excluded_pages',
            [
                'type'              => 'array',
                'sanitize_callback' => function ($input) {
                    if (!is_array($input)) {
                        return [];
                    }
                    return array_map('intval', $input); // page IDs
                },
                'default' => [],
            ]
        );
    }

    public function sanitize_settings($input)
    {
        return [
            'enabled' => isset($input['enabled']) ? 1 : 0,
            'api_key' => sanitize_text_field($input['api_key'] ?? ''),
        ];
    }

    public static function thanoz_is_local_base()
    {
        $baseDir = __DIR__; // or dirname(__FILE__) in older PHP
        return stripos($baseDir, 'xampp') !== false;
    }

    public static function getFullUrlOrigin()
    {
        $result = array();
        $result['origin'] = '';
        $result['ssl'] = false;
        $result['domain'] = '';
        $result['port'] = '';


        // Detect protocol
        if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') {
            $protocol = 'https://';
        } else {
            $protocol = 'http://';
        }
        // Detect host
        $host = $_SERVER['HTTP_HOST'] ?? $_SERVER['SERVER_NAME'] ?? 'localhost';
        $port = $_SERVER['SERVER_PORT'] ?? null;
        $isDefaultPort = ($protocol === 'https://' && $port == 443) || ($protocol === 'http://' && $port == 80);


        $result['port'] = $port;
        if ($port == 443) {
            $result['ssl'] = true;
        }
        $result['domain'] = $host;
        $result['origin'] = $protocol . $host; // ohne port

        // 
        if (thanozassistant::thanoz_is_local_base()) {
            $protocol = 'http://';
            $result['ssl'] = false;
        } else {
            $protocol = 'https://';
            $result['ssl'] = true;
        }

        return $result;
    }




    public function settings_page()
    {

        $active_tab = $_GET['tab'] ?? 'general';
        $active_tab = sanitize_key($active_tab);


        $licenseIsActive = false;
        $domaindetails = array();
        $AdminAjaxApiKeyURL = get_option('TOPTRUST_AJAX_APIKEY_URL');
        $domainname = get_option('TOPTRUST_DOMAINNAME');

        $domaindetails = thanozassistant::getFullUrlOrigin();
        if ($domaindetails['origin'] !== '') {
            $domainname = $domaindetails['origin'];
        }


        $isOnline = 1;
        $meinString = $domainname;
        $findMich   = '.local'; // 
        $pos = strpos($meinString, $findMich);
        if ($pos === false) {
            $isOnline = 1;
            $AdminAjaxApiKeyURL = get_option('TOPTRUST_AJAX_APIKEY_URL_SSL');
        } else {
            $isOnline = 0;
            $AdminAjaxApiKeyURL = get_option('TOPTRUST_AJAX_APIKEY_URL');
        }

        function checkApiKey($AdminAjaxApiKeyURL)
        {

            $responseData = array();

            $apiKey = get_option('TOPTRUST_API_KEY');
            $license = get_option('TOPTRUST_LICENSE');
            $domaindetails = thanozassistant::getFullUrlOrigin();
            $domainname = '';
            if ($domaindetails['origin'] !== '') {
                $domainname = $domaindetails['origin'];
            }

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $AdminAjaxApiKeyURL);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
            ]);
            $data = array();


            if (!$license) {
                $license = '';
            }

            $data = [
                "apikey" => $apiKey,
                "license" => $license,
                "origin" => $domaindetails['origin'],
                "ssl" => $domaindetails['ssl'],
                "domain" => $domaindetails['domain'],
                "hostingsys" => 'wordpress',
            ];


            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            // echo '<pre>admin resp.: ';
            // var_dump($response);
            // die();

            if ($httpCode !== 200) {
                // die(json_encode(['success' => false, 'message' => 'API-Server antwortet nicht oder Fehler.']));
            }
            if ($response === false) {
                echo 'cURL Error: ' . curl_error($ch);
            } else {
                $responseData = json_decode($response, true);
            }
            curl_close($ch);

            if (isset($responseData['pk'])) {
                if (trim($responseData['pk']) != '') {
                    update_option('TOPTRUST_PUB', json_encode($responseData['pk']));
                    unset($responseData['pk']);
                }
            }
            if (isset($responseData['shopguid'])) {
                if (trim($responseData['shopguid']) != '') {
                    update_option('TOPTRUST_SHOPGUID', $responseData['shopguid']);
                    unset($responseData['shopguid']);
                }
            }


            $proof = validateApiKey($responseData);
            if ($proof['isValid']) {
                $responseData['validUntil'] = $proof['validUntil'];
                $responseData['licenseIsActive'] = $proof['licenseIsActive'];
            } else {
                $responseData = array();
                update_option('TOPTRUST_LICENSE', '');
                update_option('TOPTRUST_PUB', '');
                update_option('TOPTRUST_SHOPGUID', '');
            }

            return $responseData;
        }


        function validateApiKey($responseData)
        {
            $isvalid = true;
            $licenseIsActive = false;
            $expiresAt = '';

            if (isset($responseData['data'])) {
                $data = json_encode($responseData['data'], JSON_UNESCAPED_SLASHES);
                $signature = base64_decode($responseData['signature']);
                $publicKey = json_decode(get_option('TOPTRUST_PUB'));
                $verified = 0;
                if ($publicKey != '') {
                    $verified = openssl_verify($data, $signature, $publicKey, OPENSSL_ALGO_SHA256);
                }

                if ($verified !== 1) {
                    $isvalid = false;
                }
                $expiresAt = '';
                if (isset($responseData['data']['expires_at'])) {
                    $expiresAt = $responseData['data']['expires_at'];
                    if (time() > $expiresAt) {
                        $isvalid = false;
                    }
                } else {
                    $isvalid = false;
                }
                if ($isvalid) {
                    $licenseIsActive = true;
                }
            }
            $proof = array();
            $proof['isValid'] = $isvalid;
            if ($expiresAt != '') {
                $proof['validUntil'] = date("Y-m-d H:i:s", $expiresAt);
            } else {
                $proof['validUntil'] = ' - kein Datum angegeben';
            }
            $proof['licenseIsActive'] = $licenseIsActive;

            return $proof;
        }


        $hidden_field_name = 'savetoptrustapikey';
        $apiKey = get_option('TOPTRUST_API_KEY');
        if (isset($_POST[$hidden_field_name]) && $_POST[$hidden_field_name] == 'savetoptrustapikey') {
            $apiKey = get_option('TOPTRUST_API_KEY');
            update_option('TOPTRUST_API_KEY', $apiKey);


            $domaindetails = thanozassistant::getFullUrlOrigin();
            if ($domaindetails['origin'] !== '') {
                $domainname = $domaindetails['origin'];
            }
            update_option('TOPTRUST_DOMAINNAME', $domainname);


            $responseData = checkApiKey($AdminAjaxApiKeyURL);

            if (isset($responseData['signature'])) {
                if (trim($responseData['signature']) !== '') {

                    echo '<div class="notice notice-success is-dismissible"><p>API Key gespeichert.</p></div>';
                    update_option('TOPTRUST_LICENSE', json_encode($responseData));
                } else if (trim($responseData['signature']) === '') {
                    echo '<div class="notice notice-error is-dismissible"><p>Der API Key ist ungültig oder für diese Domain nicht freigeschaltet.</p></div>';
                }
            } else {
                echo '<div class="notice notice-error is-dismissible"><p>Der API Key ist ungültig oder für diese Domain nicht freigeschaltet.</p></div>';
            }
        } else {
            $responseData = checkApiKey($AdminAjaxApiKeyURL);
            if (isset($responseData['signature'])) {
                if (trim($responseData['signature']) !== '') {

                    $validUntil = '';
                    if (isset($responseData['validUntil'])) {
                        if (trim($responseData['validUntil']) !== '') {
                            $validUntil = ' Wenn bis zum ' . $responseData['validUntil'] . ' ein erneuter Zugriff über das Internet erfolgt, verlängert sich die Lizenz automatisch.';
                        }
                    }
                    $validUntil = '';

                    if (isset($responseData['errortype'])) {
                        if (intval($responseData['errortype']) === 1) {
                            $validUntil = ' Der API Key wurde gesperrt, da eine Manipulation der Lizenzdatei erkannt wurde. Durch Zurücksetzen der Lizenzdaten kann er erneut aktiviert werden, sofern die Lizenz gültig ist, ansonsten fordern Sie bitte einen neuen API Key im Thanoz Backend an.';
                        }
                    }


                    echo '<div class="notice notice-success is-dismissible"><p>Der API Key ist gültig.</p></div>';
                    update_option('TOPTRUST_LICENSE', json_encode($responseData));
                } else if (trim($responseData['signature']) === '') {
                    echo '<div class="notice notice-error is-dismissible"><p>Der API Key ist ungültig oder für diese Domain nicht freigeschaltet.</p></div>';
                }
            } else {
                echo '<div class="notice notice-error is-dismissible"><p>Der API Key ist ungültig oder für diese Domain nicht freigeschaltet.</p></div>';
            }
        }

        $showSaveButtonForAPiKey = 1;
        if (isset($responseData['licenseIsActive'])) {
            if ($responseData['licenseIsActive']) {
                $showSaveButtonForAPiKey = 0;
            }
        }

?>


        <div class="wrap">
            <h1><?php esc_html_e('Thanoz Einstellungen', 'thanoz'); ?></h1>
            <p><b><?php esc_html_e('Intelligenter KI-Assistent, der Inhalte Ihrer Website versteht und wie ein Mensch antwortet.', 'thanoz'); ?></b></p>
            <p><?php esc_html_e('Mit dem Assistenten Thanoz steuern Sie Ihre Kundenkommunikation auf einem neuen Niveau.', 'thanoz'); ?></p>

            <h2 class="nav-tab-wrapper">
                <a href="?page=thanoz-settings&tab=general" class="nav-tab <?= $active_tab === 'general' ? 'nav-tab-active' : '' ?>">THANOZ <?php esc_html_e('KONTO', 'thanoz'); ?></a>
                <!-- <a href="?page=kiservicedino-settings&tab=advanced" class="nav-tab <?= $active_tab === 'advanced' ? 'nav-tab-active' : '' ?>">API-KEY</a> -->
            </h2>

            <div class="kiservicedino-settings-wrap">
                <form method="post" action="options.php">
                    <input type="hidden" name="<?php echo $hidden_field_name; ?>" value="savetoptrustapikey">
                    <?php
                    settings_fields('toptrust_settings_group'); // 
                    $apiKey = get_option('TOPTRUST_API_KEY');
                    ?>

                    <?php if ($active_tab === 'general') : ?>
                        <br />
                        <h2 style="margin-top: 0;"><?php esc_html_e('Gewinnen Sie mehr Zeit für relevante Prozesse', 'thanoz'); ?></h2>
                        <h2><?php esc_html_e('Steigern Sie Ihre Kundenzufriedenheit und Verkaufszahlen!', 'thanoz'); ?></h2>
                        <p style="margin-bottom: 1.5em;">
                            <?php esc_html_e('Sobald Sie Ihre Webseite mit dem Ki-Assistenten Thanoz verbunden haben, steht Ihnen die Service-Welt für besseres Kundenmarketing offen.', 'thanoz'); ?><br />
                            <?php esc_html_e('Der Service-Assistent bietet Ihren Kunden vereinfachten Zugriff auf alle relevanten Kontaktarten und stellt KI-gestützt organisationsbezogene Informationen selbstständig und in menschlicher Sprache dar.', 'thanoz'); ?>
                        </p>

                        <?php if ($showSaveButtonForAPiKey == 1) { ?>
                            <h3><strong><?php esc_html_e('Holen Sie sich Ihren API-KEY und starten Sie voll durch.', 'thanoz'); ?></strong></h3>

                            <div class="form-section" style="margin: 1.5em 0;">
                                <a href="https://thanoz.com/company-login" class="button button-secondary" target="_blank">
                                    <?php esc_html_e('Thanoz mit Ihrem Unternehmen verbinden und Kampagne starten', 'thanoz'); ?>
                                </a>
                            </div>
                        <?php } ?>

                        <div class="form-section" style="margin: 2em 0;">
                            <h2><label for="api_key" style="font-weight: bold; display: block; margin-bottom: 0.5em;"><?php esc_html_e('API-Schlüssel', 'thanoz'); ?></label></h2>
                            <input type="text" id="TOPTRUST_API_KEY" name="TOPTRUST_API_KEY" value="<?php echo esc_attr($apiKey) ?>" size="50" style="margin-bottom: 1em; width: 100%; max-width: 500px;" <?php if ($showSaveButtonForAPiKey == 0) {
                                                                                                                                                                                                                echo 'readonly';
                                                                                                                                                                                                            } ?> />
                            <input type="hidden" id="TOPTRUST_API_DOMAINNAME" name="TOPTRUST_API_DOMAINNAME" class="form-control" value="http://prestashopdev.local">
                        </div>


                        <?php if ($showSaveButtonForAPiKey == 0) { ?>
                            <h2 style="margin-bottom: 1.5em;"><?php esc_html_e('Im Systemportal können Sie den KI-Assistenten Thanoz vollumfänglich konfigurieren.', 'thanoz'); ?></h2>
                            <div class="form-section" style="margin-bottom: 2em;">
                                <label style="font-weight: bold; display: block; margin-bottom: 0.5em;"><?php esc_html_e('Mein Thanoz', 'thanoz'); ?>:</label>
                                <a href="https://thanoz.com/company-login" class="button button-secondary" target="_blank"><?php esc_html_e('SYSTEMPORTAL ÖFFNEN', 'thanoz'); ?></a>
                            </div>
                        <?php } ?>

                        <?php submit_button('Speichern'); ?>

                    <?php elseif ($active_tab === 'advanced') : ?>


                    <?php endif; ?>
                </form>
            </div>

        </div>
        <?php
    }
}



// API-Routen
// https://DOMAIN/wp-json/thanoz/v1/filtered-posts
add_action('rest_api_init', function () {
    register_rest_route('thanoz/v1', '/filtered-posts', [
        'methods'  => 'GET',
        'callback' => function (WP_REST_Request $request) {
            // API Key from DB
            $apiKey      = get_option('TOPTRUST_API_KEY');
            $providedKey = $request->get_param('apikey'); // ?apikey=xxxx
            $config      = $request->get_param('cs');     // ?cs=xxxx

            // API key check
            if (empty($providedKey) || $providedKey !== $apiKey) {
                return new WP_REST_Response([
                    'success' => false,
                    'message' => 'Invalid API Key'
                ], 403);
            }

            // CS check
            if (empty($config)) {
                return new WP_REST_Response([
                    'success' => false,
                    'message' => 'Missing cs parameter'
                ], 400);
            }

            // Fetch posts
            // Load selected post types
            $selected_post_types = get_option('thanoz-assistant_post_types', ['post']);
            // Ensure array
            if (!is_array($selected_post_types)) {
                $selected_post_types = maybe_unserialize($selected_post_types); //
                if (!is_array($selected_post_types)) {
                    $selected_post_types = explode(',', $selected_post_types); // 
                }
            }
            $excluded_pages = get_option('thanoz-assistant_excluded_pages', []);

            // Ensure array
            if (!is_array($excluded_pages)) {
                $excluded_pages = maybe_unserialize($excluded_pages); // 
                if (!is_array($excluded_pages)) {
                    $excluded_pages = explode(',', $excluded_pages); // 
                }
            }

            $query = new WP_Query([
                'post_type'      => $selected_post_types,
                'post__not_in'   => $excluded_pages,
                'posts_per_page' => 100,
                // 'post_status'    => 'publish',
            ]);

            $posts = [];
            if ($query->have_posts()) {
                while ($query->have_posts()) {
                    $query->the_post();
                    $posts[] = [
                        'id'      => get_the_ID(),
                        'link'    => get_permalink(),
                        'title'   => get_the_title(),
                        'content' => ['rendered' => get_the_content()],
                        'permalink' => get_permalink(),
                    ];
                }
                wp_reset_postdata();
            }

            return new WP_REST_Response([
                'success' => true,
                'count'   => count($posts),
                'posts'   => $posts,
                'cs'      => $config, // return token 
            ], 200);
        },
        'permission_callback' => '__return_true'
    ]);
});

// REST API route to get all post types
add_action('rest_api_init', function () {

    function thanoz_validate_request($request)
    {
        $apiKey      = get_option('TOPTRUST_API_KEY');
        $providedKey = $request->get_param('apikey');
        $config      = $request->get_param('cs');

        if (empty($providedKey) || $providedKey !== $apiKey) {
            return new WP_Error('invalid_api_key', 'Invalid API Key', ['status' => 403]);
        }

        if (empty($config)) {
            return new WP_Error('missing_cs', 'Missing cs parameter', ['status' => 400]);
        }

        return true;
    }

    // GET route: fetch all post types
    register_rest_route('thanoz/v1', '/post-types', [
        'methods'  => 'GET',
        'callback' => function (WP_REST_Request $request) {
            $check = thanoz_validate_request($request);
            if (is_wp_error($check)) return $check;

            $post_types = get_post_types([], 'objects'); // all post types
            $result = [];

            foreach ($post_types as $pt) {
                $result[] = [
                    'name'  => $pt->name,
                    'label' => $pt->label,
                ];
            }

            return [
                'success'    => true,
                'post_types' => $result,
            ];
        },
        'permission_callback' => '__return_true'
    ]);

    // POST route: save selected post types
    register_rest_route('thanoz/v1', '/post-types', [
        'methods'  => 'POST',
        'callback' => function (WP_REST_Request $request) {
            $check = thanoz_validate_request($request);
            if (is_wp_error($check)) return $check;

            $selected = $request->get_param('selected_post_types');
            if (!is_array($selected)) {
                return new WP_Error('invalid_data', 'Selected post types must be an array', ['status' => 400]);
            }

            update_option('thanoz-assistant_post_types', $selected);

            return [
                'success' => true,
                'message' => 'Selected post types saved',
                'selected_post_types' => $selected,
            ];
        },
        'permission_callback' => '__return_true'
    ]);
});


// Available post types (excluding system internals)
add_action('rest_api_init', function () {
    register_rest_route('thanoz/v1', '/available-post-types', [
        'methods'  => 'GET',
        'callback' => function (WP_REST_Request $request) {
            // API Key prüfen
            $apiKey      = get_option('TOPTRUST_API_KEY');
            $providedKey = $request->get_param('apikey');
            $config      = $request->get_param('cs');

            if (empty($providedKey) || $providedKey !== $apiKey) {
                return new WP_REST_Response([
                    'success' => false,
                    'message' => 'Invalid API Key'
                ], 403);
            }

            if (empty($config)) {
                return new WP_REST_Response([
                    'success' => false,
                    'message' => 'Missing cs parameter'
                ], 400);
            }

            // Alle Post Types holen
            $all_post_types = get_post_types([], 'objects');
            $excluded = [
                'revision',
                'nav_menu_item',
                'custom_css',
                'customize_changeset',
                'oembed_cache',
                'user_request',
                'wp_block',
                'wp_template',
                'wp_navigation',
                'wp_font_family',
                'attachment',
                'wp_font_face',
                'wp_template_part',
                'wpcf7_contact_form',
                'wp_global_styles'
            ];

            $post_types = [];
            foreach ($all_post_types as $name => $obj) {
                if (in_array($name, $excluded, true)) {
                    continue;
                }
                $post_types[] = [
                    'name'  => $name,
                    'label' => $obj->label,
                ];
            }

            // Alle Pages holen
            $pages = get_pages();
            $page_list = [];
            foreach ($pages as $page) {
                $page_list[] = [
                    'id'    => $page->ID,
                    'title' => $page->post_title,
                ];
            }

            // Gespeicherte Auswahl laden
            $selected_post_types = get_option('thanoz-assistant_post_types', ['post']);
            if (!is_array($selected_post_types)) {
                $selected_post_types = maybe_unserialize($selected_post_types);
                if (!is_array($selected_post_types)) {
                    $selected_post_types = explode(',', $selected_post_types);
                }
            }

            $excluded_pages = get_option('thanoz-assistant_excluded_pages', []);
            if (!is_array($excluded_pages)) {
                $excluded_pages = maybe_unserialize($excluded_pages);
                if (!is_array($excluded_pages)) {
                    $excluded_pages = explode(',', $excluded_pages);
                }
            }

            return new WP_REST_Response([
                'success'             => true,
                'post_types'          => $post_types,
                'selected_post_types' => $selected_post_types,
                'pages'               => $page_list,
                'excluded_pages'      => $excluded_pages,
                'cs'                  => $config,
            ], 200);
        },
        'permission_callback' => '__return_true'
    ]);
});


add_action('rest_api_init', function () {
    register_rest_route('thanoz/v1', '/set-post-types', [
        'methods'  => 'POST',
        'callback' => function (WP_REST_Request $request) {
            // API Key prüfen
            $apiKey      = get_option('TOPTRUST_API_KEY');
            $providedKey = $request->get_param('apikey');
            $config      = $request->get_param('cs');

            if (empty($providedKey) || $providedKey !== $apiKey) {
                return new WP_REST_Response([
                    'success' => false,
                    'message' => 'Invalid API Key'
                ], 403);
            }

            if (empty($config)) {
                return new WP_REST_Response([
                    'success' => false,
                    'message' => 'Missing cs parameter'
                ], 400);
            }

            // Erwartet Array mit post_types
            $selected = $request->get_param('post_types');

            if (empty($selected) || !is_array($selected)) {
                return new WP_REST_Response([
                    'success' => false,
                    'message' => 'Missing or invalid post_types array'
                ], 400);
            }

            // Sicherstellen, dass nur gültige Post Types gespeichert werden
            $valid_post_types = get_post_types([], 'names');
            $filtered = array_values(array_intersect($selected, $valid_post_types));

            update_option('thanoz-assistant_post_types', $filtered);

            return new WP_REST_Response([
                'success' => true,
                'saved'   => $filtered,
                'cs'      => $config
            ], 200);
        },
        'permission_callback' => '__return_true'
    ]);
});


add_action('rest_api_init', function () {
    register_rest_route('thanoz/v1', '/set-excluded-pages', [
        'methods'  => 'POST',
        'callback' => function (WP_REST_Request $request) {
            $apiKey      = get_option('TOPTRUST_API_KEY');
            $providedKey = $request->get_param('apikey');
            $config      = $request->get_param('cs');

            if (empty($providedKey) || $providedKey !== $apiKey) {
                return new WP_REST_Response([
                    'success' => false,
                    'message' => 'Invalid API Key'
                ], 403);
            }

            if (empty($config)) {
                return new WP_REST_Response([
                    'success' => false,
                    'message' => 'Missing cs parameter'
                ], 400);
            }

            $excluded_pages = $request->get_param('excluded_pages');
            if (!is_array($excluded_pages)) {
                return new WP_REST_Response([
                    'success' => false,
                    'message' => 'Missing or invalid excluded_pages array'
                ], 400);
            }

            update_option('thanoz-assistant_excluded_pages', array_map('intval', $excluded_pages));

            return new WP_REST_Response([
                'success'        => true,
                'excluded_pages' => $excluded_pages,
                'cs'             => $config
            ], 200);
        },
        'permission_callback' => '__return_true'
    ]);
});


// Bypass 
add_filter('rest_authentication_errors', function ($access) {
    if (is_wp_error($access)) {
        $current_route = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '';

        // Allow our custom routes 
        if (
            strpos($current_route, '/wp-json/thanoz/v1/filtered-posts') !== false ||
            strpos($current_route, '/wp-json/thanoz/v1/changed-posts') !== false ||
            strpos($current_route, '/wp-json/thanoz/v1/post-types') !== false ||
            strpos($current_route, '/wp-json/thanoz/v1/available-post-types') !== false ||
            strpos($current_route, '/wp-json/thanoz/v1/set-post-types') !== false ||
            strpos($current_route, '/wp-json/thanoz/v1/set-excluded-pages') !== false
        ) {
            return true; // bypass login requirement for others
        }

        // Other routes remain protected
        return $access;
    }
    return $access;
}, 9999);



// Create sync table on activation
register_activation_hook(__FILE__, function () {
    global $wpdb;

    $table = $wpdb->prefix . 'thanoz_sync';

    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE IF NOT EXISTS $table (
    post_id BIGINT(20) UNSIGNED NOT NULL,
    hash CHAR(32) NOT NULL,
    last_synced_at DATETIME DEFAULT '1970-01-01 00:00:00',
    PRIMARY KEY (post_id)
) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);


    $posts = get_posts([
        'post_type' => get_option('thanoz-assistant_post_types', ['post']),
        'post_status' => 'publish',
        'numberposts' => -1
    ]);

    foreach ($posts as $post) {
        $hash = md5($post->post_title . $post->post_content);
        $wpdb->replace($table, [
            'post_id' => $post->ID,
            'hash' => $hash,
            'last_synced_at' => current_time('mysql'),
        ]);
    }
});

// Utility: check and update hash for a single post
function thanoz_check_and_update_post($post_id)
{
    global $wpdb;
    $table = $wpdb->prefix . "thanoz_sync";

    $post = get_post($post_id);
    if (!$post || $post->post_status !== 'publish') {
        return false;
    }

    $content = $post->post_title . '|' . wp_strip_all_tags($post->post_content);
    $hash    = md5($content);

    $row = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table WHERE post_id = %d", $post_id));

    if (!$row || $row->last_hash !== $hash) {
        $wpdb->replace($table, [
            'post_id'     => $post_id,
            'last_hash'   => $hash,
            'last_synced' => current_time('mysql'),
        ]);
        return true; // changed
    }

    return false; // no change
}

// REST endpoint for changed posts
add_action('rest_api_init', function () {
    register_rest_route('thanoz/v1', '/changed-posts', [
        'methods'  => 'GET',
        'callback' => function (WP_REST_Request $request) {
            global $wpdb;

            $table = $wpdb->prefix . 'thanoz_sync';

            // Parameters
            $init   = $request->get_param('init');
            $since  = $request->get_param('since');
            $offset = intval($request->get_param('offset') ?: 0);
            $limit  = intval($request->get_param('limit') ?: 100);

            $apiKey      = get_option('TOPTRUST_API_KEY');
            $providedKey = $request->get_param('apikey');
            $config      = $request->get_param('cs');

            // API key check
            if (empty($providedKey) || $providedKey !== $apiKey) {
                return new WP_REST_Response([
                    'success' => false,
                    'message' => 'Invalid API Key'
                ], 403);
            }

            // CS token check
            if (empty($config)) {
                return new WP_REST_Response([
                    'success' => false,
                    'message' => 'Missing cs parameter'
                ], 400);
            }

            // Get selected post types and excluded pages
            $selected_post_types = get_option('thanoz-assistant_post_types', ['post']);
            // Ensure array
            if (!is_array($selected_post_types)) {
                $selected_post_types = maybe_unserialize($selected_post_types); // 
                if (!is_array($selected_post_types)) {
                    $selected_post_types = explode(',', $selected_post_types); //
                }
            }
            $excluded_pages = get_option('thanoz-assistant_excluded_pages', []);

            // Ensure array
            if (!is_array($excluded_pages)) {
                $excluded_pages = maybe_unserialize($excluded_pages); //
                if (!is_array($excluded_pages)) {
                    $excluded_pages = explode(',', $excluded_pages); // 
                }
            }

            // Query posts
            $query_args = [
                'post_type'      => $selected_post_types,
                'post__not_in'   => $excluded_pages,
                'posts_per_page' => $limit,
                'offset'         => $offset,
                'post_status'    => 'publish',
                'orderby'        => 'ID',
                'order'          => 'ASC'
            ];

            if (!$init && $since) {
                $query_args['date_query'] = [
                    'after' => $since,
                ];
            }

            $query = new WP_Query($query_args);
            $posts = [];

            foreach ($query->posts as $post) {
                $current_hash = md5($post->post_title . $post->post_content);

                // Get stored hash first
                $row = $wpdb->get_row($wpdb->prepare(
                    "SELECT hash FROM $table WHERE post_id = %d",
                    $post->ID
                ));

                // Only include post if initial sync or content changed
                if ($init || !$row || $row->hash !== $current_hash) {
                    $posts[] = [
                        'id'      => $post->ID,
                        'title'   => $post->post_title,
                        'content' => ['rendered' => $post->post_content],
                        'hash'    => $current_hash,
                        'permalink' => get_permalink($post),
                    ];

                    // Insert/update table
                    $wpdb->replace($table, [
                        'post_id'        => $post->ID,
                        'hash'           => $current_hash,
                        'last_synced_at' => current_time('mysql'),
                    ]);
                }
            }

            return new WP_REST_Response([
                'success' => true,
                'count'   => count($posts),
                'posts'   => $posts,
                'mode'    => $init ? 'init' : 'incremental',
                'offset'  => $offset,
                'limit'   => $limit
            ], 200);
        },
        'permission_callback' => '__return_true'
    ]);
});


add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'kiservicedino_settings_link');
function kiservicedino_settings_link($links)
{
    $settings_link = '<a href="' . admin_url('admin.php?page=thanoz-settings') . '">Einstellungen</a>';
    // array_unshift($links, $settings_link); // Add at the beginning left
    array_push($links, $settings_link); // Right 
    return $links;
}

add_action('admin_enqueue_scripts', 'kiservicedino_enqueue_admin_styles');
function kiservicedino_enqueue_admin_styles($hook)
{
    if (isset($_GET['page']) && $_GET['page'] === 'thanoz-settings') {
        wp_enqueue_style('select2-css', plugin_dir_url(__FILE__) . '/assets/css/select2.min.css');
        wp_enqueue_script('select2-js', plugin_dir_url(__FILE__) . '/assets/js/select2.full.min.js', ['jquery'], null, true);

        add_action('admin_footer', function () {
        ?>
            <script>
                jQuery(document).ready(function($) {
                    $('#post_types_select, #excluded_pages_select').select2({
                        width: '100%',
                        placeholder: 'Wähle aus...',
                        allowClear: true
                    });
                });
            </script>
<?php
        });
    }
}

function custom_admin_menu_styles()
{
    echo '<style>
#wpcontent{
    background:#fff!important;

}
#wpbody-content ,#wpwrap{
	
	background: #fff !important;
}
    </style>';
}
add_action('admin_head', 'custom_admin_menu_styles');


new thanozassistant();


function kiservicedino_install_plugin()
{
    global $wpdb;

    $table_name = $wpdb->prefix . 'toptrust';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
    `id_toptrust` int(11) NOT NULL AUTO_INCREMENT,
    `orderdata` TEXT NOT NULL,
    `reference` VARCHAR(20) NOT NULL,
    `email` VARCHAR(100) NOT NULL,
    `hook` VARCHAR(50) NOT NULL,
    `synced` TINYINT(1) NOT NULL,
    `createdat` DATETIME NOT NULL,
    `del` TINYINT(1) NOT NULL,
    PRIMARY KEY  (`id_toptrust`)
    ) $charset_collate;";

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta($sql);
}


register_activation_hook(__FILE__, 'kiservicedino_install_plugin');

add_action('rest_api_init', function () {
    register_rest_route('custom/v1', '/toptrust-config', [
        'methods' => 'GET',
        'callback' => function () {
            return [
                'apikey' => get_option('TOPTRUST_API_KEY'),
                'apiurl' => get_option('TOPTRUST_AJAX_DATA_URL_SSL'),
            ];
        },
        'permission_callback' => function () {
            return current_user_can('manage_options'); // false = public access
        },
    ]);
});


function kiservicedino_plugin_deactivate()
{
    delete_option('TOPTRUST_API_KEY');
    delete_option('TOPTRUST_LIVE_MODE');
    delete_option('TOPTRUST_LICENSE');
    delete_option('TOPTRUST_PUB');
    delete_option('TOPTRUST_SHOPGUID');
    delete_option('TOPTRUST_NAME');
    delete_option('TOPTRUST_DOMAINNAME');
    delete_option('TOPTRUST_AJAX_APIKEY_URL');
    delete_option('TOPTRUST_AJAX_APIKEY_URL_SSL');
}
register_deactivation_hook(__FILE__, 'kiservicedino_plugin_deactivate');


function kiservicedino_plugin_activate()
{
    if (!get_option('TOPTRUST_LIVE_MODE')) {
        update_option('TOPTRUST_LIVE_MODE', false);
    }
    if (!get_option('TOPTRUST_NAME')) {
        update_option('TOPTRUST_NAME', 'Top-Trust');
    }
    if (!get_option('TOPTRUST_AJAX_APIKEY_URL')) {
        update_option('TOPTRUST_AJAX_APIKEY_URL', 'http://admin.dgoit.local/rest/lic/receive/apikey');
    }
    if (!get_option('TOPTRUST_AJAX_APIKEY_URL_SSL')) {
        update_option('TOPTRUST_AJAX_APIKEY_URL_SSL', 'https://admin.dgoit.de/rest/lic/receive/apikey');
    }
    if (!get_option('TOPTRUST_AJAX_DATA_URL_SSL')) {
        update_option('TOPTRUST_AJAX_DATA_URL_SSL', 'https://plugins.dgoit.de/openai/save/settings/general/');
    }
    if (!get_option('TOPTRUST_DOMAINNAME')) {
        update_option('TOPTRUST_DOMAINNAME', 'https://admin.dgoit.de/rest/lic/receive/apikey');
    }
    if (!get_option('TOPTRUST_SHOPGUID')) {
        update_option('TOPTRUST_SHOPGUID', '');
    }
    if (!get_option('TOPTRUST_API_KEY')) {
        update_option('TOPTRUST_API_KEY', '');
    }
    if (!get_option('TOPTRUST_LICENSE')) {
        update_option('TOPTRUST_LICENSE', '');
    }
    if (!get_option('TOPTRUST_PUB')) {
        update_option('TOPTRUST_PUB', '');
    }
    if (!get_option('TOPTRUST_NAME')) {
        update_option('TOPTRUST_NAME', 'Top-Trust');
    }
}
register_activation_hook(__FILE__, 'kiservicedino_plugin_activate');


function thanoz_load_textdomain()
{
    load_plugin_textdomain(
        'thanoz', // == Text Domain
        false,
        dirname(plugin_basename(__FILE__)) . '/languages'
    );
}
add_action('plugins_loaded', 'thanoz_load_textdomain');

// if (function_exists('is_plugin_active')) {
//     echo 'Current locale: ' . get_locale();
//     die();
// }

function kiservicedino_enqueue_scripts()
{

    $AdminAjaxApiKeyURL = '';

    $result = array();
    $result['origin'] = '';
    $result['ssl'] = false;
    $result['domain'] = '';
    $result['port'] = '';

    if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') {
        $protocol = 'https://';
    } else {
        $protocol = 'http://';
    }

    $host = $_SERVER['HTTP_HOST'] ?? $_SERVER['SERVER_NAME'] ?? 'localhost';
    $port = $_SERVER['SERVER_PORT'] ?? null;
    $isDefaultPort = ($protocol === 'https://' && $port == 443) || ($protocol === 'http://' && $port == 80);


    $result['port'] = $port;
    if ($port == 443) {
        $result['ssl'] = true;
    }
    $result['domain'] = $host;
    $result['origin'] = $protocol . $host;
    $domaindetails = $result;

    $domainname = get_option('TOPTRUST_DOMAINNAME');
    if (!$domainname) {
        $domainname = get_option('TOPTRUST_DOMAINNAME'); // ??
        if ($domaindetails['origin'] !== '') {
            $domainname = $domaindetails['origin'];
        }
    }


    $isOnline = 1;
    if ($domaindetails['ssl']) {
        $isOnline = 1;
        $AdminAjaxApiKeyURL = 'https://top-trust.de/customerreviews/';
        $AdminAjaxApiKeyBadgeURL = 'https://thanoz.com/rest/users/get/user/customerreviews/thanoz/';
    } else {
        $isOnline = 0;
        $AdminAjaxApiKeyURL = 'http://top-trust.local/customerreviews/';
        $AdminAjaxApiKeyBadgeURL = 'http://thanoz.local/rest/users/get/user/customerreviews/thanoz/';
    }
    wp_enqueue_script(
        'ki-servicedino-frontend',
        plugin_dir_url(__FILE__) . 'assets/js/frontend.js',
        [],
        '1.0',
        true
    );
    wp_localize_script('ki-servicedino-frontend', 'kiservicedinodata', [
        'kiservicedinoshopguid' => $shopguid = get_option('TOPTRUST_SHOPGUID'),
        'toptrust_path' => WP_PLUGIN_URL  . '/thanoz-assistant',
        'ttbadgeurl' => $AdminAjaxApiKeyBadgeURL,
        'isOnline' => $isOnline,
    ]);
}


add_action('wp_enqueue_scripts', 'kiservicedino_enqueue_scripts');

function kiservicedino_add_styles()
{
    wp_enqueue_style('thanoz-assistant', 'https://d15ykslx8ageez.cloudfront.net/assets/css/style_thanoz-assistant.min.css');
};
add_action('get_header', 'kiservicedino_add_styles');

function kiservicedino_footer_add_styles()
{
    wp_enqueue_script('thanoz-assistant', 'https://d15ykslx8ageez.cloudfront.net/assets/js/script_thanoz-assistant.min.js', false);
};
add_action('get_footer', 'kiservicedino_footer_add_styles');
